/*
* This file is part of Wakanda software, licensed by 4D under
*  (i) the GNU General Public License version 3 (GNU GPL v3), or
*  (ii) the Affero General Public License version 3 (AGPL v3) or
*  (iii) a commercial license.
* This file remains the exclusive property of 4D and/or its licensors
* and is protected by national and international legislations.
* In any event, Licensee's compliance with the terms and conditions
* of the applicable license constitutes a prerequisite to any use of this file.
* Except as otherwise expressly stated in the applicable license,
* such license does not include any other license or rights on this file,
* 4D's and/or its licensors' trademarks and/or other proprietary rights.
* Consequently, no title, copyright or other proprietary rights
* other than those specified in the applicable license is granted.
*/
#ifndef __LegacyLanguageTypes__
#define __LegacyLanguageTypes__

#pragma pack( push, 2 )

//==============================================================================
// champvar definition


#define RUNTIME4D_MAX_NB_ARGUMENTS 128
#define EXTERNALS_MAX_NB_ARGUMENTS 25

// if you change the value of reflimit or varlimit, don't forget to update
// VARSTR_MAX_LENGTH and REFSTR_MAX_LENGTH in VTypes.h
#define reflimit 31
#define varlimit 31
typedef uBYTE				stref[reflimit+1];
typedef stref stvar;

typedef sLONG8	llong;
typedef double freal;

struct datum
{
    sWORD                   jour;
    sWORD                   mois;
    sWORD                   annee;
};

struct tfixrec
{
    sWORD	lenfix;
    sWORD	suite;
};

struct STBlob
{
	sLONG					len;
	Handle					h;
};

typedef tfixrec            *tfixptr;
typedef tfixptr            *tfixhandle;

const sLONG TEXT4D_MAXCHARS = 32000;		// typkind quelq, used in ccrecord struct
const sWORD ALPHA4D_MAXCHARS = 255;			// typkind alpha (currently for fields only)


// in argument list generated by 4D Compiler,
// the return type contains in low order byte:
// - in Ascii databases:	the Ascii length,
// - in Unicode databases:	a bit field with thread safety bit
#define PackedTypeThreadSafeMask 0x0080

struct ccrecord
{
	// try to not access this fields directly.
	// prefer member functions or ccrecord_xxx() in calculs.cpp
	
    sWORD			len;
    uBYTE**			cc;
    
#ifndef COMPILING_4DCOMPILER
	sLONG			GetLength() const			{ return (len >= 0) ? len : ((cc == nullptr) ? 0 : ::GetHandleSize((Handle)cc)); }
	void			SetLength( sLONG inLen)		{ len = (inLen > 32000) ? -1 : (sWORD) inLen;} // YT 29-May-2008 - ACI0058056 - was: inLen >= 32000

	const uBYTE*	GetPointer() const			{return (cc == nullptr) ? nullptr : *cc;}	// dangling pointer !! (you may need to lock)
	uBYTE*			GetPointer()				{return (cc == nullptr) ? nullptr : *cc;}	// dangling pointer !! (you may need to lock)

	void			Clear()						{ if (cc != nullptr) ::DisposeHandle((Handle)cc); cc = nullptr; len = 0; }

	bool			Concat( const uBYTE *inString1, const uBYTE *inString2, sLONG inLen1, sLONG inLen2);

	bool			Assign( const uBYTE *inString, sLONG inLen);
	bool			Assign( ConstStringPtr inString)	{return Assign( &inString[1], inString[0]);}
	bool			Assign( const ccrecord& inString);
 #endif
   
};

typedef ccrecord            arrssh[20001];
typedef ccrecord             *arrsshptr;
typedef arrsshptr          *arrsshhandle;

typedef Handle**			arrqdpichandle;

typedef STBlob              arrblob[20001];
typedef STBlob             *arrblobptr;
typedef arrblobptr          *arrblobhandle;

typedef XBOX::VInlineString**		arrunihandle;

typedef XBOX::VJSONObject***		arrobjecthandle;

typedef XBOX::VPicture***		arrpicturehandle;

typedef class V4DPointer***		arrpointerhandle;

typedef struct bittabarr { uBYTE data[20000]; } bittabarr;
typedef bittabarr          *bittabptr;
typedef bittabptr          *bittabhandle;

typedef freal               frealtab[20001];
typedef freal           *frealtabptr;
typedef frealtabptr        *frealtabhandle;

typedef sWORD               inttab[100001L];
typedef sWORD             *inttabptr;
typedef inttabptr          *inttabhandle;

typedef sLONG                longinttab[100001L];
typedef sLONG         *longinttabptr;
typedef longinttabptr      *longinttabhandle;

typedef llong               llongtab[100001L];
typedef llong           *llongtabptr;
typedef llongtabptr        *llongtabhandle;

typedef datum               datumtab[100001L];
typedef datum           *datumtabptr;
typedef datumtabptr        *datumtabhandle;


namespace d4_enums
{
enum vartyp : uCHAR
{
    vlocal,
    vGlobal,
    vglobglob,
	vparam,
	guessVarRange = 10
};
};

enum class Stack4DFrameID : uLONG	// this is intentionally an enum to forbid implicit conversion from an integer
{
	current = 0,
	invalid = 0xffffffff
};
const Stack4DFrameID Stack4DFrameCurrent = Stack4DFrameID::current;
const Stack4DFrameID Stack4DFrameInvalid = Stack4DFrameID::invalid;

// WARNING: this struct is assumed by 4d compiler and old generated code and plugins.
struct pointeurrec
{
    uBYTE				isvar;
	d4_enums::vartyp	xlocal;
    union {
        struct {
            stvar			varname;
            sLONG			indice;
			Stack4DFrameID	fLocalStackStamp;
        } v0;
        struct {
            sWORD           numcrit;
            sWORD           numfile;
            sWORD           nbsous;
            sWORD           sous[5];
        } v1;
    } variant;
};

typedef pointeurrec        *pointeurptr;
typedef pointeurptr        *pointeurhandle;

typedef pointeurrec         pointetab[30001];
typedef pointeurrec          *pointetabptr;
typedef pointetabptr       *pointetabhandle;

#if VERSION_LINUX
// 'timex' is the name of a struct in timex.h
#define timex _timex
#endif

namespace d4_enums
{
enum typkind : uCHAR
{
    alpha,
    reel,
    quelq, // C_TEXT
    graph, // C_GRAPH (obsolete). Attention: c'est aussi la constante utilisee pour la definition des champs de type image (a remapper sur graph2)
    date,
    aucun,
    Bool4D,
    multi,
    entier,
    longentier,
    graph2, // C_PICTURE
    timex,
    anytype,
    tableau,
    tableaur,
    tableaui,
    tableaul,
    tableaud,
    tableaua,
    tableaupict,
    tableaupointe,
    tableaufix,
    tableaub,
    xpointe,			// deprecated pointeurrec
    alpha2,
    long8,
    tableaull,
    oldreel,
	reel8Bytes,
	tableauReel8Bytes,
	blob,
	tableaublob,
	tableautimex,		// L.E. 27/08/98 support PARTIEL des tableaux d'heures pour joel
	kind_unicode,		// VString*
	tableau_unicode,	// VString*
	tk_float,			// sc 22/06/2006, reserved (DB4D/SQL compatibility)
	soap_xml,			// YT 28-Feb-2008 reserved for SOAP
	soap_dom_ref,		// YT 28-Feb-2008 reserved for SOAP
	tk_object,			// C_OBJECT
	tableau_object,		// ARRAY OBJECT
	tk_pointer,			// V4DPointer
	tableau_pointer,	// V4DPointer**
	tk_array,			// VJSONArray

	#if WITH(AST_INTERPRETER)
	runtime,
	errortype,
	typkind_last = errortype,
	typkind_first = alpha,
	#endif
	tk_jsonNull = 255
};
}

/*
	Penser a synchronizer le typedef champvar de CompTypes.h dans 4D Compiler.
*/
struct champvar
{
	d4_enums::typkind		tt;

	/*
		fil has a different meaning for parameters ($0, $1, ..) and for other values:
		
		Parameters:
			fil = 0 (False) means the parameter has not been defined using a C_xxx directive, or is a C_VARIANT
			fil = 1 (True) means the parameter has been defined using a C_xxx directive and is not a C_VARIANT. Its type is frozen.
			
		Values:
			When passed to runtime4d commands, the fil is used to know if the champvar* is actually a champoper_runtime*.
			fil = 1 means the champvar* is actually NOT pointing to a champvar but to a champoper_runtime instead.
			fil != 1 means the champvar* is really pointing to a champvar.
			fil = 2 means the champvar has been declared as a C_VARIANT (only for local variables in compiled mode).
	*/
	uBYTE					fil;

	union {
		freal				r;
		llong				l8;
		datum				d;
		uBYTE				b;
		sWORD				i;
		sLONG				l;
		sLONG				time;
		XBOX::VPicture*		fPicture;
		STBlob				Blob;
		XBOX::VJSONObject*	fObject;
		XBOX::VJSONArray*	fArray;
		XBOX::VInlineString	fString;
		class V4DPointer*	fPointer;

		// warning: 4d Compiler assumes all array handles are at same offset in champvar (6 bytes from beginning)
		struct
		{
			sLONG						nbelem;
			struct champvar_array		**tab;
			sWORD						cursel;
		} v12;

		struct
		{
			sLONG				nbelem;
			arrblobhandle		tabblob;	// tableau de blob
			sWORD				cursel;
		} v14;
		struct
		{
			sLONG				nbelem;
			bittabhandle		bittab;
			sWORD				cursel;
		} v15;
		struct
		{
			sLONG				nbelem;
			frealtabhandle		tabr;
			sWORD				cursel;
		} v16;
		struct
		{
			sLONG				nbelem;
			inttabhandle		tabi;
			sWORD				cursel;
		} v17;
		struct
		{
			sLONG				nbelem;
			longinttabhandle	tabl;
			sWORD				cursel;
		} v18;
		struct
		{
			sLONG				nbelem;
			datumtabhandle		tabd;
			sWORD				cursel;
		} v19;

		struct
		{
			sLONG				nbelem;
			llongtabhandle		tabll;
			sWORD				cursel;
		} v22;
		struct
		{
			sLONG				nbelem;
			arrunihandle		tabuni;
			sWORD				cursel;
		} v23;
		struct
		{
			sLONG				nbelem;
			arrobjecthandle		tabobject;
			sWORD				cursel;
		} v24;
		struct
		{
			sLONG				nbelem;
			arrpicturehandle	tabpicture;
			sWORD				cursel;
		} v25;
		struct
		{
			sLONG				nbelem;
			arrqdpichandle		tabqdpic;	// tableau de PicHandle for legacy plugins
			sWORD				cursel;
		} v26;

		struct
		{
			sLONG				nbelem;
			arrpointerhandle	tabpointer;
			sWORD				cursel;
		} v27;

	} variant;
};

typedef champvar		*ptrchampvar;
typedef ptrchampvar		*arrptrchampvarptr;

/*	champvar_array is for arrays exclusively */
/*	sizeof( champvar_array) MUST be 12 because pluginplugins assumes that */

struct champvar_array
{
	d4_enums::typkind		tt;
	uBYTE					fil;
	union {

		// warning: 4d Compiler assumes all array handles are at same offset in champvar (6 bytes from beginning)
		struct
		{
			sLONG							nbelem;
			struct champvar_array			**tab;
			sWORD							cursel;
		} v12;
		struct
		{
			sLONG				nbelem;
			arrsshhandle		tabss;
		} v13;
		struct
		{
			sLONG				nbelem;
			arrblobhandle		tabblob;	// tableau de blob
		} v14;
		struct
		{
			sLONG				nbelem3;
			bittabhandle		bittab;
		} v15;
		struct
		{
			sLONG				nbelem4;
			frealtabhandle		tabr;
		} v16;
		struct
		{
			sLONG				nbelem5;
			inttabhandle		tabi;
		} v17;
		struct
		{
			sLONG				nbelem6;
			longinttabhandle	tabl;
		} v18;
		struct
		{
			sLONG				nbelem7;
			datumtabhandle		tabd;
		} v19;
		struct
		{
			sLONG				nbelem8;
			pointetabhandle		tabp;
		} v20;
		struct
		{
			sLONG				nbelem9;
			tfixhandle			tabfix;
		} v21;
		struct
		{
			sLONG				nbelem11;
			llongtabhandle		tabll;
		} v22;
		struct
		{
			sLONG				nbelem;
			arrunihandle		tabuni;
		} v23;
		struct
		{
			sLONG				nbelem;
			arrobjecthandle		tabobject;
		} v24;
		struct
		{
			sLONG				nbelem;
			arrpicturehandle	tabpicture;
		} v25;
		struct
		{
			sLONG				nbelem;
			arrqdpichandle		tabqdpic;	// tableau de PicHandle for legacy plugins
		} v26;
		struct
		{
			sLONG				nbelem;
			arrpointerhandle	tabpointer;
		} v27;
	} variant;
};

/*
	champvar used exclusively for plugin sdk
*/
struct champvar_plugin
{
	d4_enums::typkind		tt;
	uBYTE					fil;	// usualy 0. But may be set to 1 by PA_ExecuteCommandByID() and ext_CallObj() to indicate this is actually a var ref or a field ref (fOperation,fField,fVariable)

	union {
		struct
		{
			sWORD			lenfix;
			uBYTE			s2[256];
		} v0;	// alpha2
		uBYTE				s[256];	// alpha
		freal				r;
		datum				d;
		uBYTE				b;
		sWORD				i;
		sLONG				l;
		sLONG				time;
		pointeurrec**		pp;
		ccrecord			v6;
		XBOX::VPicture*		fPicture;
		STBlob				Blob;
		XBOX::VJSONObject*	fObject;
		XBOX::VJSONArray*	fArray;
		XBOX::VInlineString	fString;

		struct
		{
			sLONG						nbelem;
			struct champvar_array		**tab;
			sWORD						cursel;
		} v12;
		struct
		{
			sLONG				nbelem;
			arrsshhandle		tabss;
			sWORD				cursel;
		} v13;
		struct
		{
			sLONG				nbelem;
			arrblobhandle		tabblob;	// tableau de blob
			sWORD				cursel;
		} v14;
		struct
		{
			sLONG				nbelem;
			bittabhandle		bittab;
			sWORD				cursel;
		} v15;
		struct
		{
			sLONG				nbelem;
			frealtabhandle		tabr;
			sWORD				cursel;
		} v16;
		struct
		{
			sLONG				nbelem;
			inttabhandle		tabi;
			sWORD				cursel;
		} v17;
		struct
		{
			sLONG				nbelem;
			longinttabhandle	tabl;
			sWORD				cursel;
		} v18;
		struct
		{
			sLONG				nbelem;
			datumtabhandle		tabd;
			sWORD				cursel;
		} v19;
		struct
		{
			sLONG				nbelem;
			pointetabhandle		tabp;
			sWORD				cursel;
		} v20;
		struct
		{
			sLONG				nbelem;
			tfixhandle			tabfix;
			sWORD				cursel;
		} v21;
		struct
		{
			sLONG				nbelem;
			llongtabhandle		tabll;
			sWORD				cursel;
		} v22;
		struct
		{
			sLONG				nbelem;
			arrunihandle		tabuni;
			sWORD				cursel;
		} v23;
		struct
		{
			sLONG				nbelem;
			arrobjecthandle		tabobject;
			sWORD				cursel;
		} v24;
		struct
		{
			sLONG				nbelem;
			arrpicturehandle	tabpicture;
			sWORD				cursel;
		} v25;


//====================================================================================
// a few champoper fields from PA_Variable definition (only if champvar_plugin.fil is 1)

		uBYTE				fOperation;	// optyp
		struct
		{
			sWORD fField;	// to pass a field or table to PA_ExecuteCommandByID
			sWORD fTable;	// pass 0 to pass only a field
			sWORD fUnused;	// always set to zero
		} fField;
		struct
		{
			uBYTE	fName[32];
			sLONG	fIndice;		// used for pointer to array elements
			uBYTE	fType;			// 0: local, 1: process, 2: interprocess, 3: param
			uLONG	fTag;
		} fVariable;
	} variant;
//====================================================================================

};


struct varatt
{
#if SMALLENDIAN
	uWORD	filler:13;
	uWORD	isVariant:1;
    uWORD	touchepastyp:1;
    uWORD	unused:1;	// was dimmed
#else
    uWORD	unused:1;	// was dimmed
    uWORD	touchepastyp:1;
	uWORD	isVariant:1;
    uWORD	filler:13;
#endif
};

typedef varatt *varattptr;

/*
	champvar with modification stamp and some attributes.
	Same struct for both compiled and interpreted modes.
*/
struct AttributedValue
{
    varatt		fAttributes;
    uLONG		fModificationStamp;
    champvar	fValue;
};

inline AttributedValue* GetAttributedValue_unchecked( champvar *inValue)	{ return (AttributedValue *) ((char *) inValue - offsetof( AttributedValue, fValue));}
// fil==0	->	global variable (present in the global variable buffer)
// fil==1	->	token (champoper)
// fil==2	->	local variable typed as C_VARIANT (no AttributedValue prefix)
// fil==3	->	local variable or temp variable (not C_VARIANT)
inline AttributedValue* GetAttributedValue( champvar *inValue)				{ return ( (inValue != nullptr) && ((inValue->fil == 0) || (inValue->fil == 1))) ? GetAttributedValue_unchecked( inValue) : nullptr;}


// GCC a besoin que l'instantiation du template soit fait dans le mode d'alignement voulu
typedef struct GCC_BUG_WORKAROUND
{
	champvar	f1;
	champvar_array	f2;
} GCC_BUG_WORKAROUND;


//==============================================================================
//  Token definition
typedef sWORD               arr5[5];

namespace d4_enums
{
// WARNING: never change/insert/delete these enum values as these are stored as numerical in binary databases!
enum calctyp : uCHAR
{
	operation,
	fonction,
	constante,
	xcritere,
	pareng,
	parend,
	virgule,
	assigne,
	plusrien,
	variab,
	ordre,
	xproc,
	spec1,
	parametre,
	tantque,
	fintant,
	si,
	sinon,
	finsi,
	caseof,
	deuxpoint,
	endcase,
	extern4d,
	comment,
	leftbracket,
	rightbracket,
	localvar,
	errchar,
	pointeur,
	pour,
	finpour,
	repeter,
	jusqua,
	leftstring,
	rightstring,
	globglobvar,
	xconstant,
	beginSQL,
	endSQL,
	codeSQL,
	unused,
	tokenMember,
	tokenVariable,	// similar to variab but for long variable names. used only by champoper_runtime
	tokenLeftSubscript,
	tokenRightSubscript,
	tokenCall,		// used only as a distinguishing trick in grammar
	tokenForEach,
	tokenEndForEach,
	tokenMultipleStatementLine, // used only in Grammar
	tokenUse,
	tokenEndUse,
	tokenError,				// grammar.y specific error management token (used only during preprocessing phase)
	tokenClassFunction,
	tokenClassExtends,
	tokenClassConstructor,
	tokenDeclarationVar,
	tokenDeclarationType, //deprecated. Only used in 18R4 beta
	tokenDeclarationSeparator, //depreacted. Used to separate variables with a ','
	tokenPrimitiveType,
	tokenDeclarationMethod,
	tokenClassAlias,
	tokenTernary,
	tokenAndLazy,
	tokenOrLazy,
	tokenBreak,
	tokenReturn,
	tokenContinue,
	tokenOperationAssign,
	tokenClassProperty,
	tokenDeclarationMember,
	tokenLeftCollection,
	tokenRightCollection,
	tokenLeftObject,
	tokenRightObject,
	tokenLiteralMember,
	tokenVariadic,
	tokenTry,
	tokenBeginTry,
	tokenEndTry,
	tokenCatch,
	lastTokenConst // <== not really used, but must be last (m.c)
};
};

namespace d4_enums
{
enum optyp : uCHAR
{
	plus,
	moins,
	divise,
	multiplie,
	infbool,
	supbool,
	egalbool,
	difbool,
	etbool,
	oubool,
	puissance,
	infegal,
	supegal,
	fourchbool,
	homothoriz,
	homotverti,
	divent,
	xmodulo,
	xorbool,
	notbool,
	shiftrightbool,
	shiftleftbool,
	bitsetbool,
	bitclearbool,
	bittestbool,
#if WITH(AST_INTERPRETER)
	optyp_last = bittestbool,
	optyp_first = plus,
#endif
	op_contain_keyword = xmodulo	// % pour la recherche par mot cle
};
};

struct champoper_value
{
	d4_enums::typkind		tt;
	uBYTE					fil;
	union {
		uBYTE				s[256];
		freal				r;
		llong				l8;
		datum				d;
		uBYTE				b;
		sLONG				l;
		sLONG				time;
	} variant;
};


struct champoper
{
    d4_enums::calctyp		ct;
    uBYTE					fil;
    union {
		champoper_value		cha;
        d4_enums::optyp     op;
        sWORD               fo;
        struct {
            sWORD           numcrit;
            sWORD           numfile;
            sWORD           numsous;
            arr5            critsous;
        } v3;
		Str255				varname;
        Str255				procname;
		Str255				constantname;
        sWORD               numparam;
		Str255				member;
    } variant;
};


// comme champoper mais uniquement pour une operation, une reference a une variable ou un champ passe a runtime4d().
// ce n'est utilise que pour le runtime.
// attention: contrairement a champoper, le code genere par 4D Compiler assume cette structure.

struct champoper_runtime
{
    d4_enums::calctyp		ct;		// seules valeurs possibles: operation, xcritere, tokenVariable, parametre
    uBYTE					fil;	// Pour un parametre passe a runtime4d, fil = 0 ou 3 si c'est un champvar, 1 si c'est un champoper
    union {
        d4_enums::optyp     op;
        struct {
            sWORD           numcrit;
            sWORD           numfile;
            sWORD           numsous;
            arr5            critsous;
        } v3;
#if !WITH(REMOVE_LEGACY_VARIABLE_TOKEN)
        struct {
            stvar           varname;
            sLONG			ind;
            d4_enums::vartyp   islocal;
			Stack4DFrameID	fLocalStackStamp;	// valid only when the token is passed to runtime4d in interpreted mode
        } v4;	// short variable names (ct == variab)
#endif
        struct {
            d4_enums::vartyp	islocal;
			uBYTE			_unused;
            sLONG			indice1;
            sLONG			indice2;
			Stack4DFrameID	fLocalStackStamp;	// valid only when the token is passed to runtime4d in interpreted mode
            Str255			varname;
        } v5;	// long variable names (ct == tokenVariable). WARNING: structure assumed by AAsmGen::aProcessConst()
        sWORD               numparam;
    } variant;
};

typedef champoper_runtime champoper_ref;	// used only 4D compiler


//==============================================================================
// CC4D definition


enum {
    ligne,
    test
};
typedef	uCHAR	typcalc; // enum

typedef struct calcrec		*calcptr;
typedef calcptr				*calchandle;

typedef calchandle			*tabcalcptr;
typedef tabcalcptr			*tabcalchandle;
typedef calchandle			tabcalc[8192];

typedef champoper          *ptrchampoper;
struct calcrec
{
    sWORD                   next;	// L.E. en mode list, 0 si pas de break, sinon c'est l'identifiant > 0 d'un breakpoint, -2 pour un break facon v5
    sWORD                   taille;
    sWORD                   saut;
    typcalc                 ty;
    Rect                    re;
    sLONG_PTR				ch;
    sLONG_PTR				ch2;
};


#pragma pack( pop )


#endif
